/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.world;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.jayjay.dangerzone.block.Block;
import net.jayjay.dangerzone.block.Blocks;
import net.jayjay.dangerzone.entity.Entity;
import net.jayjay.dangerzone.phys.AABB;
import net.jayjay.dangerzone.world.ChunkPos;
import net.jayjay.dangerzone.world.IWorldListener;
import net.jayjay.dangerzone.world.chunk.WorldChunk;
import net.jayjay.dangerzone.world.generate.BiomeType;
import net.jayjay.dangerzone.world.generate.WorldGenerator;

public class World {
    public ArrayList<Entity> entities = new ArrayList();
    private static final int TILE_UPDATE_INTERVAL = 400;
    private static final int CHUNK_SIZE = 16;
    public final int chunkHeight = 256;
    private final ConcurrentHashMap<ChunkPos, WorldChunk> loadedChunks = new ConcurrentHashMap();
    public String worldName;
    private ArrayList<IWorldListener> levelListeners = new ArrayList();
    private int unprocessed = 0;
    private static final int NUM_THREADS = Math.max(2, Runtime.getRuntime().availableProcessors() - 1);
    private long worldSeed;
    private int renderDistance = 16;
    private WorldGenerator wg;
    private final ExecutorService tickExecutor = Executors.newFixedThreadPool(NUM_THREADS, r -> {
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.setName("World-Tick-Thread");
        return t;
    });
    private final ThreadLocal<Random> threadRandom = ThreadLocal.withInitial(() -> new Random(System.nanoTime() + Thread.currentThread().getId()));

    public World(String worldName) {
        this.worldName = worldName;
        this.worldSeed = worldName.hashCode();
        this.wg = new WorldGenerator(this, this.worldSeed, BiomeType.DEFAULT);
    }

    public WorldChunk getChunk(int chunkX, int chunkZ) {
        ChunkPos pos = new ChunkPos(chunkX, chunkZ);
        return this.loadedChunks.computeIfAbsent(pos, p -> this.generateChunk(chunkX, chunkZ));
    }

    private WorldChunk generateChunk(int chunkX, int chunkZ) {
        WorldChunk chunk = this.loadChunk(chunkX, chunkZ);
        if (chunk != null) {
            return chunk;
        }
        chunk = new WorldChunk(chunkX, chunkZ, 256);
        this.wg.generateChunk(chunk, chunkX, chunkZ, this.worldSeed, 256);
        return chunk;
    }

    public void updateLoadedChunks(double playerX, double playerZ) {
        int playerChunkX = (int)Math.floor(playerX / 16.0);
        int playerChunkZ = (int)Math.floor(playerZ / 16.0);
        HashSet<ChunkPos> chunksToKeep = new HashSet<ChunkPos>();
        int dx = -this.renderDistance;
        while (dx <= this.renderDistance) {
            int dz = -this.renderDistance;
            while (dz <= this.renderDistance) {
                int chunkX = playerChunkX + dx;
                int chunkZ = playerChunkZ + dz;
                ChunkPos pos = new ChunkPos(chunkX, chunkZ);
                chunksToKeep.add(pos);
                this.getChunk(chunkX, chunkZ);
                ++dz;
            }
            ++dx;
        }
        Iterator<Map.Entry<ChunkPos, WorldChunk>> iter = this.loadedChunks.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<ChunkPos, WorldChunk> entry = iter.next();
            if (chunksToKeep.contains(entry.getKey())) continue;
            this.saveChunk(entry.getValue());
            iter.remove();
        }
    }

    public int getSurfaceHeight(int x, int z) {
        int chunkX = Math.floorDiv(x, 16);
        int chunkZ = Math.floorDiv(z, 16);
        WorldChunk chunk = this.getChunk(chunkX, chunkZ);
        int localX = Math.floorMod(x, 16);
        int localZ = Math.floorMod(z, 16);
        int y = 255;
        while (y >= 0) {
            if (chunk.getBlock(localX, y, localZ) != 0) {
                return y;
            }
            --y;
        }
        return -1;
    }

    public boolean load() {
        return true;
    }

    public void save() {
        for (WorldChunk chunk : this.loadedChunks.values()) {
            this.saveChunk(chunk);
        }
    }

    private void saveChunk(WorldChunk chunk) {
        try {
            File chunkDir = new File(String.valueOf(this.worldName) + "_chunks");
            if (!chunkDir.exists()) {
                chunkDir.mkdirs();
            }
            File chunkFile = new File(chunkDir, "chunk_" + chunk.chunkX + "_" + chunk.chunkZ + ".dat");
            DataOutputStream file = new DataOutputStream(new GZIPOutputStream(new FileOutputStream(chunkFile)));
            file.write(chunk.blocks);
            int x = 0;
            while (x < 16) {
                int z = 0;
                while (z < 16) {
                    file.writeInt(chunk.getLightDepth(x, z));
                    ++z;
                }
                ++x;
            }
            file.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private WorldChunk loadChunk(int chunkX, int chunkZ) {
        File chunkFile;
        block5: {
            chunkFile = new File(String.valueOf(this.worldName) + "_chunks", "chunk_" + chunkX + "_" + chunkZ + ".dat");
            if (chunkFile.exists()) break block5;
            return null;
        }
        try {
            DataInputStream file = new DataInputStream(new GZIPInputStream(new FileInputStream(chunkFile)));
            WorldChunk chunk = new WorldChunk(chunkX, chunkZ, 256);
            file.readFully(chunk.blocks);
            int x = 0;
            while (x < 16) {
                int z = 0;
                while (z < 16) {
                    chunk.setLightDepth(x, z, file.readInt());
                    ++z;
                }
                ++x;
            }
            file.close();
            return chunk;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public void calcLightDepths(int x0, int z0, int x1, int z1) {
        int x = x0;
        while (x < x0 + x1) {
            int z = z0;
            while (z < z0 + z1) {
                int chunkX = Math.floorDiv(x, 16);
                int chunkZ = Math.floorDiv(z, 16);
                WorldChunk chunk = this.getChunk(chunkX, chunkZ);
                int localX = Math.floorMod(x, 16);
                int localZ = Math.floorMod(z, 16);
                int y = 255;
                while (y > 0 && !this.isLightBlocker(x, y, z)) {
                    --y;
                }
                chunk.setLightDepth(localX, localZ, y);
                ++z;
            }
            ++x;
        }
    }

    public void addListener(IWorldListener levelListener) {
        this.levelListeners.add(levelListener);
    }

    public void removeListener(IWorldListener levelListener) {
        this.levelListeners.remove(levelListener);
    }

    public boolean isLightBlocker(int x, int y, int z) {
        Block tile = Blocks.blocks[this.getBlock(x, y, z)];
        return tile == null ? false : tile.blocksLight();
    }

    public ArrayList<AABB> getCubes(AABB aABB) {
        ArrayList<AABB> aABBs = new ArrayList<AABB>();
        int x0 = (int)Math.floor(aABB.x0);
        int x1 = (int)Math.floor(aABB.x1 + 1.0f);
        int y0 = (int)Math.floor(aABB.y0);
        int y1 = (int)Math.floor(aABB.y1 + 1.0f);
        int z0 = (int)Math.floor(aABB.z0);
        int z1 = (int)Math.floor(aABB.z1 + 1.0f);
        if (y0 < 0) {
            y0 = 0;
        }
        if (y1 > 256) {
            y1 = 256;
        }
        int x = x0;
        while (x < x1) {
            int y = y0;
            while (y < y1) {
                int z = z0;
                while (z < z1) {
                    AABB aabb;
                    Block tile = Blocks.blocks[this.getBlock(x, y, z)];
                    if (tile != null && (aabb = tile.getAABB(x, y, z)) != null) {
                        aABBs.add(aabb);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return aABBs;
    }

    public boolean setBlock(int x, int y, int z, int type) {
        int localZ;
        int localX;
        int chunkZ;
        if (y < 0 || y >= 256) {
            return false;
        }
        int chunkX = Math.floorDiv(x, 16);
        WorldChunk chunk = this.getChunk(chunkX, chunkZ = Math.floorDiv(z, 16));
        if (type == chunk.getBlock(localX = Math.floorMod(x, 16), y, localZ = Math.floorMod(z, 16))) {
            return false;
        }
        chunk.setBlock(localX, y, localZ, type);
        this.calcLightDepths(x, z, 1, 1);
        for (IWorldListener listener : this.levelListeners) {
            listener.tileChanged(x, y, z);
        }
        return true;
    }

    public boolean isLit(int x, int y, int z) {
        int localZ;
        int localX;
        int chunkZ;
        if (y < 0 || y >= 256) {
            return true;
        }
        int chunkX = Math.floorDiv(x, 16);
        WorldChunk chunk = this.getChunk(chunkX, chunkZ = Math.floorDiv(z, 16));
        return y >= chunk.getLightDepth(localX = Math.floorMod(x, 16), localZ = Math.floorMod(z, 16));
    }

    public int getBlock(int x, int y, int z) {
        if (y < 0 || y >= 256) {
            return 0;
        }
        int chunkX = Math.floorDiv(x, 16);
        int chunkZ = Math.floorDiv(z, 16);
        WorldChunk chunk = this.getChunk(chunkX, chunkZ);
        int localX = Math.floorMod(x, 16);
        int localZ = Math.floorMod(z, 16);
        return chunk.getBlock(localX, y, localZ);
    }

    public boolean isSolidBlock(int x, int y, int z) {
        Block block = Blocks.blocks[this.getBlock(x, y, z)];
        return block == null ? false : block.isSolid();
    }

    public boolean isEntityInBlock(int x, int y, int z) {
        for (Entity entity : this.entities) {
            int entityX = (int)Math.floor(entity.x);
            int entityY = (int)Math.floor(entity.y);
            int entityZ = (int)Math.floor(entity.z);
            if (entityX != x || entityY != y || entityZ != z) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void tick() {
        void var7_8;
        if (this.loadedChunks.isEmpty()) {
            return;
        }
        int totalBlocks = this.loadedChunks.size() * 16 * 256 * 16;
        this.unprocessed += totalBlocks;
        int ticks = this.unprocessed / 400;
        this.unprocessed -= ticks * 400;
        if (ticks == 0) {
            return;
        }
        int ticksPerThread = Math.max(1, ticks / NUM_THREADS);
        WorldChunk[] chunkArray = this.loadedChunks.values().toArray(new WorldChunk[0]);
        int numChunks = chunkArray.length;
        if (numChunks == 0) {
            return;
        }
        ArrayList futures = new ArrayList(NUM_THREADS);
        boolean bl = false;
        while (var7_8 < NUM_THREADS) {
            int threadTicks;
            void threadId = var7_8;
            int n = threadTicks = threadId == NUM_THREADS - 1 ? ticks - ticksPerThread * (NUM_THREADS - 1) : ticksPerThread;
            if (threadTicks > 0) {
                Future<?> future = this.tickExecutor.submit(() -> {
                    Random rand = this.threadRandom.get();
                    int i2 = 0;
                    while (i2 < threadTicks) {
                        Block block;
                        int localZ;
                        int localY;
                        int localX;
                        WorldChunk chunk = chunkArray[rand.nextInt(numChunks)];
                        int blockId = chunk.getBlock(localX = rand.nextInt(16), localY = rand.nextInt(256), localZ = rand.nextInt(16));
                        if (blockId != 0 && (block = Blocks.blocks[blockId]) != null) {
                            int worldX = chunk.chunkX * 16 + localX;
                            int worldZ = chunk.chunkZ * 16 + localZ;
                            block.tick(this, worldX, localY, worldZ, rand);
                        }
                        ++i2;
                    }
                });
                futures.add(future);
            }
            ++var7_8;
        }
        for (Future future : futures) {
            try {
                future.get(100L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e2) {
                future.cancel(true);
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
        }
    }

    public Collection<WorldChunk> getLoadedChunks() {
        return this.loadedChunks.values();
    }

    public void setRenderDistance(int distance) {
        this.renderDistance = distance;
    }

    public int getRenderDistance() {
        return this.renderDistance;
    }

    public void shutdown() {
        this.save();
        this.tickExecutor.shutdown();
        try {
            if (!this.tickExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.tickExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e2) {
            this.tickExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

